/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_14; import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * @author Thomas Ekert
 * 
 */
public class ToyStoreDemo implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de:63148"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		ToyStoreDemo ts = new ToyStoreDemo ();
		NotesThread nt = new NotesThread (ts);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		ToyStore ts = null;
		Document doc = null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			ts = new ToyStore ("djbuch/djbuch.nsf", session);
			ts.addToy(1,"nasty dog");
			ts.addToy(2,"tiny dog");
			System.out.println (ts.getToy(1));
			doc = ts.getToyDocument(2);
			System.out.println (doc.getItemValueString(ToyStore.ITEM_NAME));
			ts.removeToy(1);
			ts.removeToy(2);
		} catch (NotesException e) {
			System.out.println ("id = " + e.id);
			e.printStackTrace();
		} finally {
			GC.recycle (doc);
			if (ts!=null) {
				ts.recycle();
			}
			GC.recycle(session);
		}
	}
}
